<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ventas</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.3/css/dataTables.bootstrap5.min.css">
</head>

<style>
    .form-control {
        font-size: 14px;
        padding: 5px 10px;
        height: 30px;
    }

    .form-SELECT {
        font-size: 14px;
        padding: 5px 10px;
        height: 30px;
    }

    /* Color naranja para los bordes de las tarjetas */
    .card {
        border: 2px solid #f75b0b;
    }

    .card-header {
        background-color: #f75b0b;
        color: white;
    }

    /* Color naranja para el botón */
    .btn-primary {
        background-color: #f75b0b;
        border-color: #f75b0b;
    }

    .btn-primary:hover {
        background-color: #e04e2c;
        border-color: #e04e2c;
    }
</style>
<style>
    .preview-container {
        margin: 20px 0;
    }

    .preview-container img {
        max-width: 50%;
        height: 200px;
        display: block;
    }
</style>

<body>

    <div class="container-fluid">
        <h1>Ventas</h1>
        <table id="ventasTable" class="table table-striped table-bordered table-sm" style="width:100%">
            <thead class="text-center small">
                <tr>
                    <!-- Aquí todas las columnas -->
                    <th>ID</th>
                    <th>Estado</th>
                    <th>VER</th>
                    <th>Imagen Score</th>
                    <th>DNI Vendedor</th>
                    <th>Documento</th>
                    <th>Nombres</th>
                    <th>Apellidos</th>
                    <th>Tipo Documento</th>
                    <th>Imagen Delantera Documento</th>
                    <th>Imagen Trasera Documento</th>
                    <th>Celular</th>
                    <th>WhatsApp</th>



                    <th>Precio</th>
                </tr>
            </thead>
            <tbody class="text-center small">
                <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($venta->id); ?></td>
                        <td> <?php
                            $estado = $venta->estado;
                        ?>

                            <?php switch($estado):
                                case (0): ?>
                                    <span class="badge bg-secondary">GESTIONANDO</span>
                                <?php break; ?>

                                <?php case (1): ?>
                                    <span class="badge bg-light text-dark">PENDIENTE</span>
                                <?php break; ?>

                                <?php case (2): ?>
                                    <span class="badge bg-warning text-dark">OBSERVADO</span>
                                <?php break; ?>

                                <?php case (3): ?>
                                    <span class="badge bg-primary">APROBADO</span>
                                <?php break; ?>

                                <?php case (4): ?>
                                    <span class="badge bg-danger">DESAPROBADO</span>
                                <?php break; ?>

                                <?php case (5): ?>
                                    <SPAN class="badge text-bg-dark">CARGADO</span>
                                <?php break; ?>

                                <?php case (6): ?>
                                    <span class="badge bg-success">INSTALADO</span>
                                <?php break; ?>

                                <?php default: ?>
                                    <span class="badge bg-secondary">UNKNOWN</span>
                            <?php endswitch; ?>
                        </td>
                        </td>

                        <td>
                            <a href="#" onclick="verDetalles(<?php echo e($venta->id); ?>)">
                                <i class="bi bi-search"></i>
                            </a>
                        </td>


                        <td> <a href="<?php echo e(url('/download/' . $venta->imagenScore)); ?>" class="btn btn-primary">
                                Descargar
                            </a></td>


                        <td><?php echo e($venta->dnivendedor); ?></td>
                        <td><?php echo e($venta->tipoDocumento); ?></td>
                        <td><?php echo e($venta->nombres); ?></td>
                        <td><?php echo e($venta->apellidos); ?></td>
                        <td><?php echo e($venta->documento); ?></td>

                        <td>
                            <a href="<?php echo e(url('/download/' . $venta->imagenDelanteraDocumento)); ?>"
                                class="btn btn-primary">
                                Descargar
                            </a>
                        </td>
                        <td>
                            <a href="<?php echo e(url('/download/' . $venta->imagenTraseraDocumento)); ?>" class="btn btn-primary">
                                Descargar
                            </a>
                        </td>
                        <td><?php echo e($venta->celular); ?></td>
                        <td><?php echo e($venta->whatsapp); ?></td>




                        <td><?php echo e($venta->precio); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Modal Structure -->
    <div class="modal fade" id="ventaModal" tabindex="-1" aria-labelledby="ventaModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ventaModalLabel">Detalles de la Venta</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="formulario" enctype="multipart/form-data">

                        <!-- Datos del Titular Card -->
                        <div class="card mb-4">
                            <div class="card-header">
                                Datos del Titular
                            </div>

                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-8">
                                        <label for="imagenScore">Imagen Score</label>

                                        <div class="preview-container">
                                            <img id="previewScore" src=""
                                                alt="Vista previa de la Imagen del Score" style="display: none;">
                                        </div>

                                    </div>
                                    <div class="col-md-4">
                                        <label for="dnivendedor">DNI Vendedor</label>
                                        <input disabled type="text" class="form-control solo-numeros" maxlength="8"
                                            id="dnivendedor" name="dnivendedor" placeholder="Ingrese DNI">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <label for="nombres">Nombres</label>
                                        <input disabled type="text" class="form-control" id="nombres"
                                            name="nombres" placeholder="Ingrese sus nombres">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="apellidos">Apellidos</label>
                                        <input disabled type="text" class="form-control" id="apellidos"
                                            name="apellidos" placeholder="Ingrese sus apellidos">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="tipoDocumento">Tipo de Documento</label>
                                        <select disabled class="form-control" id="tipoDocumento" name="tipoDocumento">

                                            <option value="DNI">DNI</option>
                                            <option value="PASAPARTE">PASAPARTE</option>
                                            <option value="CARNET DE EXTRANJERIA">CARNET DE EXTRANJERIA</option>
                                            <option value="RUC">RUC</option>

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="documento">Documento</label>
                                        <input disabled type="text" class="form-control solo-numeros" maxlength="8"
                                            id="documento" name="documento" placeholder="Ingrese su documento">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="imagenDelanteraDocumento">Imagen Delantera Documento
                                            Identidad</label>

                                        <div class="preview-container">
                                            <img id="previewDelantera" src=""
                                                alt="Vista previa de la Imagen Delantera del Documento"
                                                style="display: none;">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="imagenTraseraDocumento">Imagen Trasera Documento Identidad</label>


                                        <div class="preview-container">
                                            <img id="previewTrasera" src=""
                                                alt="Vista previa de la Imagen Trasera del Documento"
                                                style="display: none;">
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="celular">Celular Contacto</label>
                                        <input disabled type="text" class="form-control solo-numeros"
                                            maxlength="9" id="celular" name="celular"
                                            placeholder="Ingrese su celular">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="whatsapp">Whatsapp Contacto</label>
                                        <input disabled type="text" class="form-control solo-numeros"
                                            maxlength="9" id="whatsapp" name="whatsapp"
                                            placeholder="Ingrese su Whatsapp">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="correo">Correo</label>
                                        <input disabled type="email" class="form-control" id="correo"
                                            name="correo" placeholder="Ingrese su correo">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Dirección y Relación con el Predio Card -->
                        <div class="card mb-4">
                            <div class="card-header">
                                Dirección y Relación con el Predio
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="departamento">Departamento</label>


                                        <select disabled class="form-control selectpicker" id="departamento"
                                            name="departamento">
                                            <option value="LIMA">LIMA</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="provincia">Provincia</label>


                                        <select disabled class="form-control" id="provincia" name="provincia">
                                            <option value="LIMA">LIMA</option>
                                            <option value="CALLAO">CALLAO</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="distrito">Distrito</label>


                                        <select disabled class="form-control" id="distrito" name="distrito">
                                            <option value="CALLAO">CALLAO</option>
                                            <option value="BELLAVISTA">BELLAVISTA</option>
                                            <option value="CARMEN DE LA LEGUA REYNOSO">CARMEN DE LA LEGUA REYNOSO
                                            </option>
                                            <option value="LA PERLA">LA PERLA</option>
                                            <option value="LA PUNTA">LA PUNTA</option>
                                            <option value="VENTANILLA">VENTANILLA</option>
                                            <option value="MI PERU">MI PERU</option>
                                            <option value="LIMA">LIMA</option>
                                            <option value="ANCON">ANCON</option>
                                            <option value="ATE">ATE</option>
                                            <option value="BARRANCO">BARRANCO</option>
                                            <option value="BREÑA">BREÑA</option>
                                            <option value="CARABAYLLO">CARABAYLLO</option>
                                            <option value="CHACLACAYO">CHACLACAYO</option>
                                            <option value="CHORRILLOS">CHORRILLOS</option>
                                            <option value="CIENEGUILLA">CIENEGUILLA</option>
                                            <option value="COMAS">COMAS</option>
                                            <option value="EL AGUSTINO">EL AGUSTINO</option>
                                            <option value="INDEPENDENCIA">INDEPENDENCIA</option>
                                            <option value="JESUS MARIA">JESUS MARIA</option>
                                            <option value="LA MOLINA">LA MOLINA</option>
                                            <option value="LA VICTORIA">LA VICTORIA</option>
                                            <option value="LINCE">LINCE</option>
                                            <option value="LOS OLIVOS">LOS OLIVOS</option>
                                            <option value="LURIGANCHO">LURIGANCHO</option>
                                            <option value="LURIN">LURIN</option>
                                            <option value="MAGDALENA DEL MAR">MAGDALENA DEL MAR</option>
                                            <option value="PUEBLO LIBRE">PUEBLO LIBRE</option>
                                            <option value="MIRAFLORES">MIRAFLORES</option>
                                            <option value="PACHACAMAC">PACHACAMAC</option>
                                            <option value="PUCUSANA">PUCUSANA</option>
                                            <option value="PUENTE PIEDRA">PUENTE PIEDRA</option>
                                            <option value="PUNTA HERMOSA">PUNTA HERMOSA</option>
                                            <option value="PUNTA NEGRA">PUNTA NEGRA</option>
                                            <option value="RIMAC">RIMAC</option>
                                            <option value="SAN BARTOLO">SAN BARTOLO</option>
                                            <option value="SAN BORJA">SAN BORJA</option>
                                            <option value="SAN ISIDRO">SAN ISIDRO</option>
                                            <option value="SAN JUAN DE LURIGANCHO">SAN JUAN DE LURIGANCHO</option>
                                            <option value="SAN JUAN DE MIRAFLORES">SAN JUAN DE MIRAFLORES</option>
                                            <option value="SAN LUIS">SAN LUIS</option>
                                            <option value="SAN MARTIN DE PORRES">SAN MARTIN DE PORRES</option>
                                            <option value="SAN MIGUEL">SAN MIGUEL</option>
                                            <option value="SANTA ANITA">SANTA ANITA</option>
                                            <option value="SANTA MARIA DEL MAR">SANTA MARIA DEL MAR</option>
                                            <option value="SANTA ROSA">SANTA ROSA</option>
                                            <option value="SANTIAGO DE SURCO">SANTIAGO DE SURCO</option>
                                            <option value="SURQUILLO">SURQUILLO</option>
                                            <option value="VILLA EL SALVADOR">VILLA EL SALVADOR</option>
                                            <option value="VILLA MARIA DEL TRIUNFO">VILLA MARIA DEL TRIUNFO</option>
                                            <option value="SANTA MARIA DE HUACHIPA">SANTA MARIA DE HUACHIPA</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">

                                    <div class="col-md-7">
                                        <label for="direccion">Dirección</label>
                                        <input disabled type="text" class="form-control" id="direccion"
                                            name="direccion" placeholder="Ingrese su dirección">
                                    </div>
                                    <div class="col-md-2">
                                        <label for="piso">Piso</label>
                                        <select disabled class="form-control" id="piso" name="piso">
                                            <option value="1">1</option>

                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            <option value="5">5</option>
                                            <option value="6">6</option>
                                            <option value="7">7</option>
                                            <option value="8">8</option>
                                            <option value="9">9</option>
                                            <option value="10">10</option>
                                            <option value="11">11</option>
                                            <option value="12">12</option>
                                            <option value="13">13</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="casa">Tipo de Domicilio</label>
                                        <select disabled class="form-control" id="tcasa" name="tcasa">


                                            <option value="CASA">CASA</option>
                                            <option value="DEPARTAMENTO">DEPARTAMENTO</option>
                                            <option value="EDIFICIO">EDIFICIO</option>
                                            <option value="CONDOMINIO">CONDOMINIO</option>

                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="referencia">Referencia</label>
                                        <input disabled type="text" class="form-control" id="referencia"
                                            name="referencia" placeholder="Ingrese una referencia">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="coordenadas">Coordenadas</label>
                                        <input disabled type="text" class="form-control" id="coordenadas"
                                            name="coordenadas" placeholder="Ingrese las coordenadas">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="relacionPredio">Relación con el Predio</label>
                                        <select disabled class="form-control" id="relacionPredio"
                                            name="relacionPredio">


                                            <option value="PROPIETARIO">PROPIETARIO</option>
                                            <option value="INQUILINO">INQUILINO</option>
                                            <option value="OTRO">OTRO</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Información del Producto Card -->

                        <!-- Información del Producto Card -->
                        <div class="card mb-4">
                            <div class="card-header">
                                Información del Producto
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">

                                    <div class="col-md-3">
                                        <label for="tipoDocumentoTitular">Tipo de Plan Contrato</label>
                                        <select disabled class="form-control" id="plancliente" name="plancliente">
                                            <option value="0" selected>--Seleccione--</option>

                                            <option value="1">MONO</option>
                                            <option value="2">DUO</option>
                                            <option value="3">TRIO</option>
                                            <option value="4">GAMER</option>
                                            <option value="5">RUC20</option>
                                        </select>
                                    </div>

                                    <div class="col-md-3">
                                        <label for="parentesco">Plan Contratado</label>
                                        <select disabled class="form-control" id="plancontrato" name="plancontrato">

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="operador">Cuotas instalación</label>
                                        <select disabled class="form-control" id="cuota" name="cuota">
                                            <option value="GRATIS">GRATIS</option>
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="2">3</option>

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="operador">Cantidad de Mesh</label>
                                        <select disabled class="form-control" id="canmesh" name="canmesh">
                                            <option>0</option>
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>

                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <label for="operador"> Mesh Cableado</label>
                                        <select disabled class="form-control" id="mecableado" name="mecableado">
                                            <option value="NO">NO</option>
                                            <option value="SI">SI</option>


                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="operador"> Winbox</label>
                                        <select disabled class="form-control" id="winbo" name="winbo">
                                            <option value="NO">NO</option>
                                            <option value="SI">SI</option>


                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="nombresTitularLinea">Numero a portar Fijo</label>
                                        <input disabled type="text" class="form-control" id="portatnumeot"
                                            name="portatnumeot"
                                            placeholder="Ingrese los nombres del titular de la línea">
                                    </div>


                                </div>
                            </div>
                        </div>
                        <!-- Información del Titular de la Línea Card -->
                        <div class="card mb-4">
                            <div class="card-header">
                                Información del Titular de la Línea (VERIFICAR https://checatuslineas.osiptel.gob.pe/ )
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-2">
                                        <label for="nombresTitularLinea">NOMBRES </label>
                                        <input disabled type="text" class="form-control" id="nombresTitularLinea"
                                            name="nombresTitularLinea"
                                            placeholder="Ingrese los nombres del titular de la línea">
                                    </div>
                                    <div class="col-md-2">
                                        <label for="nombresTitularLinea">APELLIDOS </label>
                                        <input disabled type="text" class="form-control"
                                            id="apellidosTitularLinea" name="apellidosTitularLinea"
                                            placeholder="Ingrese los nombres del titular de la línea">
                                    </div>
                                    <div class="col-md-2">
                                        <label for="tipoDocumentoTitular">Tipo de Documento</label>
                                        <select disabled class="form-control" id="tipoDocumentoTitular"
                                            name="tipoDocumentoTitular">

                                            <option value="DNI">DNI</option>
                                            <option value="PASAPARTE">PASAPARTE</option>
                                            <option value="CARNET DE EXTRANJERIA">CARNET DE EXTRANJERIA</option>
                                            <option value="RUC">RUC</option>

                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="documentoTitular">Documento</label>
                                        <input disabled type="text" class="form-control" id="documentoTitular"
                                            name="documentoTitular" placeholder="Ingrese el documento">
                                    </div>
                                    <div class="col-md-2">
                                        <label for="parentesco">Parentesco</label>
                                        <select disabled class="form-control" id="parentesco" name="parentesco">
                                            <option value="TITULAR">TITULAR</option>
                                            <option value="PADRE/MADRE">PADRE/MADRE</option>
                                            <option value="HERMANO/HERMANA">HERMANO/HERMANA</option>
                                            <option value="ESPOSO/ESPOSA">ESPOSO/ESPOSA</option>
                                            <option value="HIJO/HIJA">HIJO/HIJA</option>
                                            <option value="OTRO">OTRO</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="operador">Operador</label>
                                        <select disabled class="form-control" id="operador" name="operador">
                                            <option value="ENTEL">ENTEL</option>
                                            <option value="MOVISTAR">MOVISTAR</option>
                                            <option value="CLARO">CLARO</option>
                                            <option value="BITEL">BITEL</option>

                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label for="observacion">Observación</label>
                                        <textarea disabled class="form-control" id="observacion" name="observacion" rows="3"
                                            placeholder="Ingrese alguna observación"></textarea>
                                    </div>
                                </div>
                                <button type="button" id="enviarFormulario" class="btn btn-primary">Enviar</button>
                            </div>
                        </div>
                    </form>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.js"
        integrity="sha512-+k1pnlgt4F1H8L7t3z95o3/KO+o78INEcXTbnoJQ/F2VqDVhWoaiVml/OEHv9HsVgxUaVW+IbiZPUJQfF/YxZw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#ventasTable').DataTable();





            //////////////////SELECT PLAN CONTRATADO
            $('#plancliente').on('change', function() {
                var filtro = $(this).val();
                $.get("<?php echo e(url('selectplanclienteid')); ?>", {
                    filtro: filtro

                }, function(data) {
                    $('#plancontrato').empty();
                    // Agregar la opción "Seleccione"
                    $('#plancontrato').append('<option value=""></option>');

                    $.each(data, function(index, item) {
                        $("#plancontrato").append('<option value="' + item.id + '">' + item
                            .nombre +
                            '</option>');
                    });
                    // Ejecuta un callback después de que las opciones se hayan cargado
                    if (typeof afterLoad === 'function') {
                        afterLoad();
                    }
                });
            });
        });
        //////////////
    </script>
    
    <script>
        function verDetalles(id) {
            $.get("<?php echo e(url('selectvemtawinid')); ?>", {
                id: id
            }, function(data) {

                var detalles = data[0]; // Accedemos al primer objeto del array
                //datos del cliente

                $('#dnivendedor').val(detalles.dnivendedor);
                $('#documento').val(detalles.dnivendedor);
                $('#nombres').val(detalles.tipoDocumento);
                $('#apellidos').val(detalles.apellidos);
                $('#tipoDocumento').val(detalles.tipoDocumento).trigger('change');
                $('#celular').val(detalles.celular);
                $('#whatsapp').val(detalles.whatsapp);
                $('#correo').val(detalles.correo);

                //datos dureccion
                $('#departamento').val(detalles.departamento).trigger('change');
                $('#provincia').val(detalles.provincia).trigger('change');
                $('#distrito').val(detalles.distrito).trigger('change');
                $('#direccion').val(detalles.direccion);

                $('#piso').val(detalles.piso).trigger('change');
                $('#tcasa').val(detalles.tdomi).trigger('change');
                $('#referencia').val(detalles.referencia);
                $('#coordenadas').val(detalles.coordenadas);
                $('#relacionPredio').val(detalles.relacionPredio).trigger('change');


                //  

                //datos del producto


                $('#plancliente').val(detalles.tipoplan).trigger('change');

                $("#plancontrato option:selected").val(detalles.plan_contra);
                /* setTimeout(function() {
                    $('#plancontrato').val(detalles.plan_contra).trigger('change');
                }, 1800); // Ajusta el tiempo si es necesario
                 */

                // Define un callback para seleccionar el valor
                window.afterLoad = function() {
                    $('#plancontrato').val(detalles.plan_contra).trigger('change');
                };
                $('#cuota').val(detalles.couta).trigger('change');
                $('#canmesh').val(detalles.canmesh).trigger('change');
                $('#meshcableado').val(detalles.meshcableado).trigger('change');
                $('#winbox').val(detalles.winbox).trigger('change');
                $('#numeroaportar').val(detalles.numeroaportar);



                //



                //datos del titular
                $('#nombresTitularLinea').val(detalles.nombresTitularLinea);
                $('#apellidosTitularLinea').val(detalles.apellidosTitularLinea);
                $('#tipoDocumentoTitular').val(detalles.tipoDocumentoTitular).trigger('change');
                $('#documentoTitular').val(detalles.documentoTitular);
                $('#parentesco').val(detalles.parentesco).trigger('change');
                $('#operador').val(detalles.operador).trigger('change');
                $('#observacion').val(detalles.observacion);

                //
                // Construir la URL de la imagen

                var imageUrl1 = "<?php echo e(url('/download')); ?>/" + encodeURIComponent(detalles.imagenScore);
                var imageUrl2 = "<?php echo e(url('/download')); ?>/" + encodeURIComponent(detalles.imagenDelanteraDocumento);
                var imageUrl3 = "<?php echo e(url('/download')); ?>/" + encodeURIComponent(detalles.imagenTraseraDocumento);
                // Actualizar la vista previa de la imagen
                $('#previewScore').attr('src', imageUrl1).show();
                $('#previewDelantera').attr('src', imageUrl2).show();
                $('#previewTrasera').attr('src', imageUrl3).show();


                // Mostrar el modal
                var myModal = new bootstrap.Modal(document.getElementById('ventaModal'), {
                    keyboard: false
                });
                myModal.show();




                //$('#tipoDocumento').find(":selected").val(detalles.tipoDocumento);
                //$('#tipoDocumento option:selected').val(detalles.tipoDocumento);

                //var dato = (detalles.tipoDocumento);
                // $("#tipoDocumento option[value='" + dato + "']").attr('selected', 'selected');

                // var dato = detalles.tipoDocumento;
                // $("#tipoDocumento").val(dato).change();
                //$("#tipoDocumento :selected").val(dato);
                // Primero deseleccionamos cualquier opción seleccionada
                // $('#tipoDocumento option').prop('selected', false);

                // Luego seleccionamos la opción que coincide con el valor
                // $('#plancontrato').val(detalles.plan_contra).trigger('change');
                // Aseguramos que `plancliente` se procese antes de seleccionar `plancontrato`

                //alert(detalles.plan_contra);
                //  $('#plancontrato').val(detalles.plan_contra).trigger('change');
                //$("#cbxtip_docup option[value='" + detalles.plan_contra + "']").attr('selected', 'selected');

            });
        }
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\appcrmkantum\resources\views/winventas/winventas_view.blade.php ENDPATH**/ ?>