<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Formulario</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">




    <style>
        .form-control {
            font-size: 14px;
            padding: 5px 10px;
            height: 30px;
        }

        .form-SELECT {
            font-size: 14px;
            padding: 5px 10px;
            height: 30px;
        }

        /* Color naranja para los bordes de las tarjetas */
        .card {
            border: 2px solid #f75b0b;
        }

        .card-header {
            background-color: #f75b0b;
            color: white;
        }

        /* Color naranja para el botón */
        .btn-primary {
            background-color: #f75b0b;
            border-color: #f75b0b;
        }

        .btn-primary:hover {
            background-color: #e04e2c;
            border-color: #e04e2c;
        }
    </style>

    <style>
        .preview-container {
            margin: 20px 0;
        }

        .preview-container img {
            max-width: 50%;
            height: 200px;
            display: block;
        }
    </style>
</head>

<body>
    <div class="container mt-5">
        <h2>Formulario de Registro</h2>
        <form id="formulario" enctype="multipart/form-data">

            <!-- Datos del Titular Card -->
            <div class="card mb-4">
                <div class="card-header">
                    Datos del Titular
                </div>

                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <label for="imagenScore">Imagen Score</label>
                            <input type="file" class="form-control-file" id="imagenScore" name="imagenScore"
                                onchange="previewImage(event, 'previewScore')">
                            <div class="preview-container">
                                <img id="previewScore" src="" alt="Vista previa de la Imagen del Score"
                                    style="display: none;">
                            </div>

                        </div>
                        <div class="col-md-4">
                            <label for="dnivendedor">DNI Vendedor</label>
                            <input type="text" class="form-control solo-numeros" maxlength="8" id="dnivendedor"
                                name="dnivendedor" placeholder="Ingrese DNI">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label for="nombres">Nombres</label>
                            <input type="text" class="form-control" id="nombres" name="nombres"
                                placeholder="Ingrese sus nombres">
                        </div>
                        <div class="col-md-3">
                            <label for="apellidos">Apellidos</label>
                            <input type="text" class="form-control" id="apellidos" name="apellidos"
                                placeholder="Ingrese sus apellidos">
                        </div>
                        <div class="col-md-3">
                            <label for="tipoDocumento">Tipo de Documento</label>
                            <select class="form-control" id="tipoDocumento" name="tipoDocumento">
                                <option disabled value="0" selected>--Seleccione--</option>

                                <option value="DNI">DNI</option>
                                <option value="PASAPARTE">PASAPARTE</option>
                                <option value="CARNET DE EXTRANJERIA">CARNET DE EXTRANJERIA</option>
                                <option value="RUC">RUC</option>
                            </select>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="documento">Documento</label>
                            <input type="text" class="form-control solo-numeros" maxlength="8" id="documento"
                                name="documento" placeholder="Ingrese su documento">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="imagenDelanteraDocumento">Imagen Delantera Documento Identidad</label>
                            <input type="file" class="form-control-file" id="imagenDelanteraDocumento"
                                onchange="previewImage(event, 'previewDelantera')" name="imagenDelanteraDocumento">

                            <div class="preview-container">
                                <img id="previewDelantera" src=""
                                    alt="Vista previa de la Imagen Delantera del Documento" style="display: none;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="imagenTraseraDocumento">Imagen Trasera Documento Identidad</label>
                            <input type="file" class="form-control-file" id="imagenTraseraDocumento"
                                onchange="previewImage(event, 'previewTrasera')" name="imagenTraseraDocumento">

                            <div class="preview-container">
                                <img id="previewTrasera" src=""
                                    alt="Vista previa de la Imagen Trasera del Documento" style="display: none;">
                            </div>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="celular">Celular Contacto</label>
                            <input type="text" class="form-control solo-numeros" maxlength="9" id="celular"
                                name="celular" placeholder="Ingrese su celular">
                        </div>
                        <div class="col-md-4">
                            <label for="whatsapp">Whatsapp Contacto</label>
                            <input type="text" class="form-control solo-numeros" maxlength="9" id="whatsapp"
                                name="whatsapp" placeholder="Ingrese su Whatsapp">
                        </div>
                        <div class="col-md-4">
                            <label for="correo">Correo</label>
                            <input type="email" class="form-control" id="correo" name="correo"
                                placeholder="Ingrese su correo">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dirección y Relación con el Predio Card -->
            <div class="card mb-4">
                <div class="card-header">
                    Dirección y Relación con el Predio
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="departamento">Departamento</label>


                            <select class="form-control selectpicker" id="departamento" name="departamento">
                                <option disabled value="0" selected>--Seleccione--</option>
                                <option value="LIMA">LIMA</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="provincia">Provincia</label>


                            <select class="form-control" id="provincia" name="provincia">
                                <option disabled value="0" selected>--Seleccione--</option>
                                <option value="LIMA">LIMA</option>
                                <option value="CALLAO">CALLAO</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="distrito">Distrito</label>


                            <select class="form-control" id="distrito" name="distrito">
                                <option disabled value="0" selected>--Seleccione--</option>
                                <option value="CALLAO">CALLAO</option>
                                <option value="BELLAVISTA">BELLAVISTA</option>
                                <option value="CARMEN DE LA LEGUA REYNOSO">CARMEN DE LA LEGUA REYNOSO
                                </option>
                                <option value="LA PERLA">LA PERLA</option>
                                <option value="LA PUNTA">LA PUNTA</option>
                                <option value="VENTANILLA">VENTANILLA</option>
                                <option value="MI PERU">MI PERU</option>
                                <option value="LIMA">LIMA</option>
                                <option value="ANCON">ANCON</option>
                                <option value="ATE">ATE</option>
                                <option value="BARRANCO">BARRANCO</option>
                                <option value="BREÑA">BREÑA</option>
                                <option value="CARABAYLLO">CARABAYLLO</option>
                                <option value="CHACLACAYO">CHACLACAYO</option>
                                <option value="CHORRILLOS">CHORRILLOS</option>
                                <option value="CIENEGUILLA">CIENEGUILLA</option>
                                <option value="COMAS">COMAS</option>
                                <option value="EL AGUSTINO">EL AGUSTINO</option>
                                <option value="INDEPENDENCIA">INDEPENDENCIA</option>
                                <option value="JESUS MARIA">JESUS MARIA</option>
                                <option value="LA MOLINA">LA MOLINA</option>
                                <option value="LA VICTORIA">LA VICTORIA</option>
                                <option value="LINCE">LINCE</option>
                                <option value="LOS OLIVOS">LOS OLIVOS</option>
                                <option value="LURIGANCHO">LURIGANCHO</option>
                                <option value="LURIN">LURIN</option>
                                <option value="MAGDALENA DEL MAR">MAGDALENA DEL MAR</option>
                                <option value="PUEBLO LIBRE">PUEBLO LIBRE</option>
                                <option value="MIRAFLORES">MIRAFLORES</option>
                                <option value="PACHACAMAC">PACHACAMAC</option>
                                <option value="PUCUSANA">PUCUSANA</option>
                                <option value="PUENTE PIEDRA">PUENTE PIEDRA</option>
                                <option value="PUNTA HERMOSA">PUNTA HERMOSA</option>
                                <option value="PUNTA NEGRA">PUNTA NEGRA</option>
                                <option value="RIMAC">RIMAC</option>
                                <option value="SAN BARTOLO">SAN BARTOLO</option>
                                <option value="SAN BORJA">SAN BORJA</option>
                                <option value="SAN ISIDRO">SAN ISIDRO</option>
                                <option value="SAN JUAN DE LURIGANCHO">SAN JUAN DE LURIGANCHO</option>
                                <option value="SAN JUAN DE MIRAFLORES">SAN JUAN DE MIRAFLORES</option>
                                <option value="SAN LUIS">SAN LUIS</option>
                                <option value="SAN MARTIN DE PORRES">SAN MARTIN DE PORRES</option>
                                <option value="SAN MIGUEL">SAN MIGUEL</option>
                                <option value="SANTA ANITA">SANTA ANITA</option>
                                <option value="SANTA MARIA DEL MAR">SANTA MARIA DEL MAR</option>
                                <option value="SANTA ROSA">SANTA ROSA</option>
                                <option value="SANTIAGO DE SURCO">SANTIAGO DE SURCO</option>
                                <option value="SURQUILLO">SURQUILLO</option>
                                <option value="VILLA EL SALVADOR">VILLA EL SALVADOR</option>
                                <option value="VILLA MARIA DEL TRIUNFO">VILLA MARIA DEL TRIUNFO</option>
                                <option value="SANTA MARIA DE HUACHIPA">SANTA MARIA DE HUACHIPA</option>

                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">

                        <div class="col-md-7">
                            <label for="direccion">Dirección</label>
                            <input type="text" class="form-control" id="direccion" name="direccion"
                                placeholder="Ingrese su dirección">
                        </div>
                        <div class="col-md-2">
                            <label for="piso">Piso</label>
                            <select class="form-control" id="piso" name="piso">
                                <option value="1" selected>1</option>

                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5">5</option>
                                <option value="6">6</option>
                                <option value="7">7</option>
                                <option value="8">8</option>
                                <option value="9">9</option>
                                <option value="10">10</option>
                                <option value="11">11</option>
                                <option value="12">12</option>
                                <option value="13">13</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="casa">Tipo de Domicilio</label>
                            <select class="form-control" id="tcasa" name="tcasa">
                                <option disabled value="0" selected>--Seleccione--</option>

                                <option value="CASA">CASA</option>
                                <option value="DEPARTAMENTO">DEPARTAMENTO</option>
                                <option value="EDIFICIO">EDIFICIO</option>
                                <option value="CONDOMINIO">CONDOMINIO</option>

                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="referencia">Referencia</label>
                            <input type="text" class="form-control" id="referencia" name="referencia"
                                placeholder="Ingrese una referencia">
                        </div>
                        <div class="col-md-4">
                            <label for="coordenadas">Coordenadas</label>
                            <input type="text" class="form-control" id="coordenadas" name="coordenadas"
                                placeholder="Ingrese las coordenadas">
                        </div>
                        <div class="col-md-4">
                            <label for="relacionPredio">Relación con el Predio</label>
                            <select class="form-control" id="relacionPredio" name="relacionPredio">
                                <option disabled value="0" selected>--Seleccione--</option>


                                <option value="PROPIETARIO">PROPIETARIO</option>
                                <option value="INQUILINO">INQUILINO</option>
                                <option value="OTRO">OTRO</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Información del Producto Card -->

            <!-- Información del Producto Card -->
            <div class="card mb-4">
                <div class="card-header">
                    Información del Producto
                </div>
                <div class="card-body">
                    <div class="row mb-3">

                        <div class="col-md-3">
                            <label for="tipoDocumentoTitular">Tipo de Plan Contrato</label>
                            <select class="form-control" id="plancliente" name="plancliente">
                                <option disabled value="0" selected>--Seleccione--</option>

                                <option value="1">MONO</option>
                                <option value="2">DUO</option>
                                <option value="3">TRIO</option>
                                <option value="4">GAMER</option>
                                <option value="5">RUC20</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="parentesco">Plan Contratado</label>
                            <select class="form-control" id="plancontrato" name="plancontrato">
                                <option disabled value="0" selected>--Seleccione--</option>

                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="operador">Cuotas instalación</label>
                            <select class="form-control" id="cuota" name="cuota">
                                <option value="GRATIS">GRATIS</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="2">3</option>


                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="operador">Cantidad de Mesh</label>
                            <select class="form-control" id="canmesh" name="canmesh">
                                <option>0</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>

                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label for="operador"> Mesh Cableado</label>
                            <select class="form-control" id="mecableado" name="mecableado">
                                <option value="NO">NO</option>
                                <option value="SI">SI</option>


                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="operador"> Winbox</label>
                            <select class="form-control" id="winbo" name="winbo">
                                <option value="NO">NO</option>
                                <option value="SI">SI</option>


                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="nombresTitularLinea">Numero a portar Fijo</label>
                            <input type="text" class="form-control" id="portatnumeot" name="portatnumeot"
                                placeholder="Ingrese los nombres del titular de la línea">
                        </div>


                    </div>
                </div>
            </div>
            <!-- Información del Titular de la Línea Card -->
            <div class="card mb-4">
                <div class="card-header">
                    Información del Titular de la Línea (VERIFICAR https://checatuslineas.osiptel.gob.pe/ )
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label for="nombresTitularLinea">NOMBRES </label>
                            <input type="text" class="form-control" id="nombresTitularLinea"
                                name="nombresTitularLinea" placeholder="Ingrese los nombres del titular de la línea">
                        </div>
                        <div class="col-md-2">
                            <label for="nombresTitularLinea">APELLIDOS </label>
                            <input type="text" class="form-control" id="apellidosTitularLinea"
                                name="apellidosTitularLinea"
                                placeholder="Ingrese los nombres del titular de la línea">
                        </div>
                        <div class="col-md-2">
                            <label for="tipoDocumentoTitular">Tipo de Documento</label>
                            <select class="form-control" id="tipoDocumentoTitular" name="tipoDocumentoTitular">
                                <option disabled value="0" selected>--Seleccione--</option>

                                <option value="DNI">DNI</option>
                                <option value="PASAPARTE">PASAPARTE</option>
                                <option value="CARNET DE EXTRANJERIA">CARNET DE EXTRANJERIA</option>
                                <option value="RUC">RUC</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="documentoTitular">Documento</label>
                            <input type="text" class="form-control" id="documentoTitular" name="documentoTitular"
                                placeholder="Ingrese el documento">
                        </div>
                        <div class="col-md-2">
                            <label for="parentesco">Parentesco</label>
                            <select class="form-control" id="parentesco" name="parentesco">
                                <option disabled value="0" selected>--Seleccione--</option>
                                <option value="TITULAR">TITULAR</option>
                                <option value="PADRE/MADRE">PADRE/MADRE</option>
                                <option value="HERMANO/HERMANA">HERMANO/HERMANA</option>
                                <option value="ESPOSO/ESPOSA">ESPOSO/ESPOSA</option>
                                <option value="HIJO/HIJA">HIJO/HIJA</option>
                                <option value="OTRO">OTRO</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="operador">Operador</label>
                            <select class="form-control" id="operador" name="operador">
                                <option disabled value="0" selected>--Seleccione--</option>
                                <option value="ENTEL">ENTEL</option>
                                <option value="MOVISTAR">MOVISTAR</option>
                                <option value="CLARO">CLARO</option>
                                <option value="BITEL">BITEL</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="observacion">Observación</label>
                            <textarea class="form-control" id="observacion" name="observacion" rows="3"
                                placeholder="Ingrese alguna observación"></textarea>
                        </div>
                    </div>
                    <button type="button" id="enviarFormulario" class="btn btn-primary">Enviar</button>
                </div>
            </div>
        </form>

    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>

</html>
<script>
    $(document).ready(function() {

        // Configurar el token CSRF para todas las solicitudes AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $('input').on('input', function() {
            // Convierte el valor de todos los campos input a mayúsculas
            $(this).val($(this).val().toUpperCase());
        });

        $('.solo-numeros').on('input', function() {
            // Reemplaza cualquier carácter que no sea un número con una cadena vacía
            $(this).val($(this).val().replace(/[^0-9]/g, ''));
        });

        $('#enviarFormulario').on('click', function() {
            var formData = new FormData($('#formulario')[0]);
            formData.append('formulario', '1');
            // Crear y añadir el spinner de Bootstrap
            $('body').append(
                '<div id="spinnerCargando" class="position-fixed w-100 h-100 d-flex justify-content-center align-items-center" style="background-color: rgba(255, 255, 255, 0.7); z-index: 1050;"><div class="spinner-border text-primary" role="status"><span class="sr-only">Cargando...</span></div></div>'
            );


            $.ajax({
                url: "{{ url('ventareg') }}",
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    alert('Datos enviados exitosamente');
                    location.reload()
                    $('#spinnerCargando').remove();
                    console.log(response);
                },
                error: function(xhr, status, error) {
                    alert('Error al enviar los datos');
                    console.error(xhr.responseText);
                }
            });
        });

        $('#plancliente').on('change', function() {
            var filtro = $(this).val();
            $.get("{{ url('selectplanclienteid') }}", {
                filtro: filtro

            }, function(data) {
                $('#plancontrato').empty();
                // Agregar la opción "Seleccione"
                $('#plancontrato').append('<option value=""></option>');

                $.each(data, function(index, item) {
                    $("#plancontrato").append('<option value="' + item.id + '">' + item
                        .nombre +
                        '</option>');
                });
                // Ejecuta un callback después de que las opciones se hayan cargado
                if (typeof afterLoad === 'function') {
                    afterLoad();
                }
            });
        });








    });
</script>

<script>
    function previewImage(event, previewId) {
        const reader = new FileReader();
        reader.onload = function() {
            const output = document.getElementById(previewId);
            output.src = reader.result;
            output.style.display = 'block';
        }
        reader.readAsDataURL(event.target.files[0]);
    }
</script>

<script>

$(document).ready(function() {
    $('#tipoDocumento').change(function() {
        var selectedValue = $(this).val();
        
        if (selectedValue === 'RUC') {
            $('#documento').attr('maxlength', '11');
            $('#documento').attr('placeholder', 'Ingrese su RUC');
        } else {
            $('#documento').attr('maxlength', '8');
            $('#documento').attr('placeholder', 'Ingrese su documento');
        }
    });


    $('#tipoDocumentoTitular').change(function() {
        var selectedValue = $(this).val();
        
        if (selectedValue === 'RUC') {
            $('#documentoTitular').attr('maxlength', '11');
            $('#documentoTitular').attr('placeholder', 'Ingrese su RUC');
        } else {
            $('#documentoTitular').attr('maxlength', '8');
            $('#documentoTitular').attr('placeholder', 'Ingrese su documento');
        }
    });
});





</script>
