<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
class WinController extends Controller
{
    public function selectwinventa()
    {
        $ventas = DB::table('TBL_WIN_VENTA')
            ->join('TBL_WIN_PLAN_CONTRATADO', 'TBL_WIN_VENTA.plan_contra', '=', 'TBL_WIN_PLAN_CONTRATADO.id')
            ->select(
                'TBL_WIN_VENTA.id',
                'TBL_WIN_VENTA.imagenScore',
                'TBL_WIN_VENTA.dnivendedor',
                'TBL_WIN_VENTA.nombres',
                'TBL_WIN_VENTA.apellidos',
                'TBL_WIN_VENTA.documento',
                'TBL_WIN_VENTA.tipoDocumento',
                'TBL_WIN_VENTA.imagenDelanteraDocumento',
                'TBL_WIN_VENTA.imagenTraseraDocumento',
                'TBL_WIN_VENTA.celular',
                'TBL_WIN_VENTA.whatsapp',
                'TBL_WIN_VENTA.correo',
                'TBL_WIN_VENTA.departamento',
                'TBL_WIN_VENTA.provincia',
                'TBL_WIN_VENTA.distrito',
                'TBL_WIN_VENTA.direccion',
                'TBL_WIN_VENTA.referencia',
                'TBL_WIN_VENTA.coordenadas',
                'TBL_WIN_VENTA.relacionPredio',
                'TBL_WIN_VENTA.nombresTitularLinea',
                'TBL_WIN_VENTA.apellidosTitularLinea',
                'TBL_WIN_VENTA.tipoDocumentoTitular',
                'TBL_WIN_VENTA.parentesco',
                'TBL_WIN_VENTA.documentoTitular',
                'TBL_WIN_VENTA.operador',
                'TBL_WIN_VENTA.observacion',
                'TBL_WIN_VENTA.tipoplan',
                'TBL_WIN_VENTA.plan_contra',
                'TBL_WIN_VENTA.couta',
                'TBL_WIN_VENTA.canmesh',
                'TBL_WIN_VENTA.meshcableado',
                'TBL_WIN_VENTA.winbox',
                'TBL_WIN_VENTA.numeroaportar',
                'TBL_WIN_VENTA.piso',
                'TBL_WIN_VENTA.tdomi',
                'TBL_WIN_VENTA.estado',
                'TBL_WIN_PLAN_CONTRATADO.tipo_plan',
                'TBL_WIN_PLAN_CONTRATADO.precio'
            )
            ->get();

        return view('winventas.winventas_view', compact('ventas'));
    }


    public function selectwinventabyid(Request $request)
    {
        $filtro = $request->input('id');

        // Obtener los datos de la base de datos utilizando el método select de DB con una cláusula WHERE
        $opciones = DB::select('SELECT
                                        TBL_WIN_VENTA.id,
                                        TBL_WIN_VENTA.imagenScore,
                                        TBL_WIN_VENTA.dnivendedor,
                                        TBL_WIN_VENTA.nombres,
                                        TBL_WIN_VENTA.apellidos,
                                        TBL_WIN_VENTA.documento,
                                        TBL_WIN_VENTA.tipoDocumento,
                                        TBL_WIN_VENTA.imagenDelanteraDocumento,
                                        TBL_WIN_VENTA.imagenTraseraDocumento,
                                        TBL_WIN_VENTA.celular,
                                        TBL_WIN_VENTA.whatsapp,
                                        TBL_WIN_VENTA.correo,
                                        TBL_WIN_VENTA.departamento,
                                        TBL_WIN_VENTA.provincia,
                                        TBL_WIN_VENTA.distrito,
                                        TBL_WIN_VENTA.direccion,
                                        TBL_WIN_VENTA.referencia,
                                        TBL_WIN_VENTA.coordenadas,
                                        TBL_WIN_VENTA.relacionPredio,
                                        TBL_WIN_VENTA.nombresTitularLinea,
                                        TBL_WIN_VENTA.apellidosTitularLinea,
                                        TBL_WIN_VENTA.tipoDocumentoTitular,
                                        TBL_WIN_VENTA.parentesco,
                                        TBL_WIN_VENTA.documentoTitular,
                                        TBL_WIN_VENTA.operador,
                                        TBL_WIN_VENTA.observacion,
                                        TBL_WIN_VENTA.tipoplan,
                                        TBL_WIN_VENTA.plan_contra,
                                        TBL_WIN_VENTA.couta,
                                        TBL_WIN_VENTA.canmesh,
                                        TBL_WIN_VENTA.meshcableado,
                                        TBL_WIN_VENTA.winbox,
                                        TBL_WIN_VENTA.numeroaportar,
                                        TBL_WIN_VENTA.piso,
                                        TBL_WIN_VENTA.tdomi,
                                        TBL_WIN_VENTA.estado,
                                        TBL_WIN_PLAN_CONTRATADO.tipo_plan,
                                        TBL_WIN_PLAN_CONTRATADO.precio
                                        FROM TBL_WIN_VENTA
                                        INNER JOIN TBL_WIN_PLAN_CONTRATADO
                                            ON TBL_WIN_VENTA.plan_contra = TBL_WIN_PLAN_CONTRATADO.id WHERE TBL_WIN_VENTA.id = ? ', [$filtro]);

     return response()->json($opciones);
       //return response()->json($opciones[0]);
    }

    public function selectplanclienteopcionesid(Request $request)
    {
        $filtro = $request->input('filtro');

        // Obtener los datos de la base de datos utilizando el método select de DB con una cláusula WHERE
        $opciones = DB::select('SELECT id, nombre FROM TBL_WIN_PLAN_CONTRATADO WHERE tipo_plan = ?', [$filtro]);

        return response()->json($opciones);
    }
    


    public function store(Request $request)
    {
       // Configuración de directorio de subida
    $uploadDir = 'documentos/dniventawin/';

    // Obtener fecha y hora actual
    $fechaHora = now()->format('Ymd_His');

    // Array para almacenar las rutas de las imágenes subidas
    $imagePaths = [];

    // Procesar la imagen del score
    if ($request->hasFile('imagenScore')) {
        $file = $request->file('imagenScore');
        $fileName = $request->input('documento') . '_score_' . $fechaHora . '.' . $file->getClientOriginalExtension();
        $file->storeAs($uploadDir, $fileName);
        $imagePaths['imagenScore'] = $fileName;
    }

    // Procesar la imagen delantera del documento
    if ($request->hasFile('imagenDelanteraDocumento')) {
        $file = $request->file('imagenDelanteraDocumento');
        $fileName = $request->input('documento') . '_frente_' . $fechaHora . '.' . $file->getClientOriginalExtension();
        $file->storeAs($uploadDir, $fileName);
        $imagePaths['imagenDelanteraDocumento'] = $fileName;
    }

    // Procesar la imagen trasera del documento
    if ($request->hasFile('imagenTraseraDocumento')) {
        $file = $request->file('imagenTraseraDocumento');
        $fileName = $request->input('documento') . '_trasera_' . $fechaHora . '.' . $file->getClientOriginalExtension();
        $file->storeAs($uploadDir, $fileName);
        $imagePaths['imagenTraseraDocumento'] = $fileName;
    }
        // Insertar datos en la base de datos, incluyendo las rutas de las imágenes
        DB::table('TBL_WIN_VENTA')->insert([
            'imagenScore' => $imagePaths['imagenScore'] ?? null,
            'dnivendedor' => $request->input('dnivendedor'),
            'nombres' => $request->input('nombres'),
            'apellidos' => $request->input('apellidos'),
            'tipoDocumento' => $request->input('tipoDocumento'),
            'documento' => $request->input('documento'),
            'imagenDelanteraDocumento' => $imagePaths['imagenDelanteraDocumento'] ?? null,
            'imagenTraseraDocumento' => $imagePaths['imagenTraseraDocumento'] ?? null,
            'celular' => $request->input('celular'),
            'whatsapp' => $request->input('whatsapp'),
            'correo' => $request->input('correo'),
            'departamento' => $request->input('departamento'),
            'provincia' => $request->input('provincia'),
            'distrito' => $request->input('distrito'),
            'direccion' => $request->input('direccion'),
            'referencia' => $request->input('referencia'),
            'coordenadas' => $request->input('coordenadas'),
            'relacionPredio' => $request->input('relacionPredio'),
            'nombresTitularLinea' => $request->input('nombresTitularLinea'),
            'apellidosTitularLinea' => $request->input('apellidosTitularLinea'),
            'tipoDocumentoTitular' => $request->input('tipoDocumentoTitular'),
            'documentoTitular' => $request->input('documentoTitular'),
            'parentesco' => $request->input('parentesco'),
            'operador' => $request->input('operador'),
            'observacion' => $request->input('observacion'),
            'tipoplan' => $request->input('plancliente'),
            'plan_contra' => $request->input('plancontrato'),
            'couta' => $request->input('cuota'),
            'canmesh' => $request->input('canmesh'),
            'meshcableado' => $request->input('mecableado'),
            'winbox' => $request->input('winbo'),
            'numeroaportar' => $request->input('portatnumeot'),
            'piso' => $request->input('piso'),
            'tdomi' => $request->input('tcasa'),
        ]);

        return redirect()->back()->with('success', 'Datos guardados exitosamente');
    }

}