<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class FileController extends Controller
{
    public function download($filename)
    {
        // Ruta completa al archivo en storage/app/private/documents
        $path = storage_path('app/documentos/dniventawin/' . $filename);

        // Verificar si el archivo existe
        if (!file_exists($path)) {
            abort(404, 'Archivo no encontrado');
        }

        // Retornar la descarga del archivo
        return response()->download($path);
    }


    public function downloa2($file){
        $file_path = public_path('uploads/cv/'.$file);
        return response()->download( $file_path);
    }
}