<?php

namespace App\Http\Controllers;

use App\Models\Empleado;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EmpleadoController extends Controller
{


    public function index()
    {
        $empleados = Empleado::all();
        return view('view_empleado/empleado', compact('empleados'));
    }


    public function crearEmpleado(Request $request)
    {
        // Validar los datos del formulario

        // Crear un nuevo empleado en la base de datos
        $empleado = new Empleado;
        $empleado->apellido_paterno = $request->apaterno;
        $empleado->apellido_materno = $request->amaterno;
        $empleado->nombres = $request->nombres;
        $empleado->documento_tipo = $request->documento;
        $empleado->numero_dni = $request->dni;
        $empleado->fecha_nacimiento = $request->fecha_nacimiento;
        $empleado->sexo = $request->sexo;
        $empleado->departamento = $request->departamento;
        $empleado->provincia = $request->provincia;
        $empleado->distrito = $request->distrito;
        $empleado->direccion = $request->direccion;
        $empleado->celular = $request->celular;
        $empleado->correo = $request->correo;
        $empleado->estado = $request->estado;
        // ... asigna otros campos aquí

        // Guardar el nuevo empleado
        $empleado->save();

        // Devolver una respuesta JSON

    }


    public function guardarAsistenciabak(Request $request)
    {
        date_default_timezone_set('America/Lima');
        $dni = $request->input('dni');


        $tipoIngreso = $request->input('tipo');

        // Verificar si ya existe un registro para el empleado en la fecha actual y con el mismo tipo
        $registroExistente = DB::table('asistencia')
            ->where('empleado', $dni)
            ->whereDate('fecha', now()->toDateString())
            ->where('tipo', $tipoIngreso)
            ->first();

        if (!$registroExistente) {
            // Si no existe, crear un nuevo registro
            DB::table('asistencia')->insert([
                'empleado' => $dni,
                'tipo' => $tipoIngreso,

            ]);

            return response()->json(['mensaje' => 'Asistencia registrada correctamente']);
        } else {
            // Si ya existe un registro con el mismo tipo para el empleado en la fecha actual, puedes manejarlo según tus necesidades
            return response()->json(['mensaje' => 'Ya existe un registro para el DNI y tipo especificados en la fecha actual.']);
        }






    }
    public function guardarAsistencia(Request $request)
    {
        date_default_timezone_set('America/Lima');


        $dni = $request->input('dni');
        $tipoIngreso = $request->input('tipo');

        // Verificar si el empleado está registrado
        $empleado = DB::table('empleados')
            ->where('numero_dni', $dni)
            ->first();

        if ($empleado) {
            // Verificar si ya existe un registro para el empleado en la fecha actual y con el mismo tipo
            $registroExistente = DB::table('asistencia')
                ->where('empleado', $empleado->id_empleado)
                ->whereDate('fecha', now()->toDateString())
                ->where('tipo', $tipoIngreso)
                ->first();

            if (!$registroExistente) {
                // Si no existe, procedemos a registrar la asistencia
                DB::table('asistencia')->insert([
                    'empleado' => $empleado->id_empleado,
                    'tipo' => $tipoIngreso,
                    // Otros campos de la asistencia...
                    
                ]);

                return response()->json(['mensaje' => 'Asistencia registrada correctamente']);
            } else {
                // Si ya existe un registro con el mismo tipo para el empleado en la fecha actual, devuelve un mensaje de error
                return response()->json(['mensaje' => 'Ya existe un registro para el DNI y tipo especificados en la fecha actual.']);
            }
        } else {
            // Si el empleado no está registrado, devuelve un mensaje de error
            return response()->json(['mensaje' => 'El empleado no está registrado.']);
        }




    }


}