<!doctype html>
<html lang="en">

<head>
    <title>Title</title>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- css datatable -->

    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">

    <!-- Bootstrap CSS v5.2.1 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">

   
</head>

<body>

    <div class="container-fluid">
        <!-- Button trigger modal -->
        <div class="row">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                Nuevo</button>
        </div>
        <div class="row mt-3">
            <table id="myTable" class="table table-striped" style="width:100%">
                <thead>
                    <tr>
                        <th>A.Paterno</th>
                        <th>A.Materno</th>
                        <th>Nombres</th>
                        <th>Documento</th>
                        <th>N° DNI</th>
                        <th>Fec. Nacimiento</th>
                        <th>Sexo</th>
                        <th>Departamento</th>
                        <th>Provincia</th>
                        <th>Distrito</th>
                        <th>Direccion</th>
                        <th>Celular</th>
                        <th>Correo</th>
                        <th>Estado</th>
                        <th>Editar</th>
                        <th>Eliminar</th>
                        <!-- Agrega más encabezados de columnas según tus necesidades -->
                    </tr>
                </thead>


                <tbody>
                    <?php $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($empleado->apellido_paterno); ?></td>
                        <td><?php echo e($empleado->apellido_materno); ?></td>
                        <td><?php echo e($empleado->nombres); ?></td>
                        <td><?php echo e($empleado->documento_tipo); ?></td>
                        <td><?php echo e($empleado->numero_dni); ?></td>
                        <td><?php echo e($empleado->fecha_nacimiento); ?></td>
                        <td><?php echo e($empleado->sexo); ?></td>
                        <td><?php echo e($empleado->departamento); ?></td>
                        <td><?php echo e($empleado->provincia); ?></td>
                        <td><?php echo e($empleado->distrito); ?></td>
                        <td><?php echo e($empleado->direccion); ?></td>
                        <td><?php echo e($empleado->celular); ?></td>
                        <td><?php echo e($empleado->correo); ?></td>
                        <td><?php echo e($empleado->estado); ?></td>
                        <td> <button type="button" class="btn btn-outline-success">Editar</button></td>
                        <td> <button type="button" class="btn btn-outline-danger">Eliminar</button></td>
                        <!-- Agrega más celdas según los campos de tu base de datos -->
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>




        <!-- Modal -->
        <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="staticBackdropLabel">Modal title</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label for="apellidoPaterno" class="form-label">Apellido Paterno</label>
                                    <input type="text" class="form-control" id="apellidoPaterno" name="apellidoPaterno">
                                </div>
                                <div class="col-md-4">
                                    <label for="apellidoMaterno" class="form-label">Apellido Materno</label>
                                    <input type="text" class="form-control" id="apellidoMaterno" name="apellidoMaterno">
                                </div>
                                <div class="col-md-4">
                                    <label for="nombres" class="form-label">Nombres</label>
                                    <input type="text" class="form-control" id="nombres" name="nombres">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label for="documento" class="form-label">Documento</label>
                                    <select class="form-select" id="documento" name="documento">
                                        <option value="dni">DNI</option>
                                        <option value="pasaporte">Pasaporte</option>
                                        <!-- Agrega más opciones según tus necesidades -->
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="numeroDNI" class="form-label">N° DNI</label>
                                    <input type="text" class="form-control" id="numeroDNI" name="numeroDNI">
                                </div>
                                <div class="col-md-4">
                                    <label for="fechaNacimiento" class="form-label">Fec. Nacimiento</label>
                                    <input type="date" class="form-control" id="fechaNacimiento" name="fechaNacimiento">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label for="sexo" class="form-label">Sexo</label>
                                    <select class="form-select" id="sexo" name="sexo">
                                        <option value="masculino">Masculino</option>
                                        <option value="femenino">Femenino</option>
                                        <!-- Agrega más opciones según tus necesidades -->
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="departamento" class="form-label">Departamento</label>
                                    <input type="text" class="form-control" id="departamento" name="departamento">
                                </div>
                                <div class="col-md-4">
                                    <label for="provincia" class="form-label">Provincia</label>
                                    <input type="text" class="form-control" id="provincia" name="provincia">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label for="distrito" class="form-label">Distrito</label>
                                    <input type="text" class="form-control" id="distrito" name="distrito">
                                </div>
                                <div class="col-md-5">
                                    <label for="direccion" class="form-label">Dirección</label>
                                    <input type="text" class="form-control" id="direccion" name="direccion">
                                </div>
                                <div class="col-md-3">
                                    <label for="celular" class="form-label">Celular</label>
                                    <input type="tel" class="form-control" id="celular" name="celular">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="correo" class="form-label">Correo</label>
                                    <input type="email" class="form-control" id="correo" name="correo">
                                </div>
                                <div class="col-md-2">
                                    <label for="estado" class="form-label">Estado</label>
                                    <select class="form-select" id="estado" name="estado">
                                        <option value="activo">Activo</option>
                                        <option value="inactivo">Inactivo</option>
                                        <!-- Agrega más opciones según tus necesidades -->
                                    </select>
                                </div>
                            </div>

                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" id="registrarEmpleadoBtn" class="btn btn-primary">Guardar</button>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <a href="https://app.kantum.pe/public/asistencia" id="enlace" target="_blank">Abrir en Nueva Ventana</a>



    <!-- jquery -->

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>

    <!-- Bootstrap JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous">
    </script>
    <!-- Bootstrap JavaScript Libraries -->

    <!-- datateble -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
   
</body>
<script>
$(document).ready(function() {
    let table = new DataTable('#myTable');

});
</script>


<script>
// Manejar la solicitud AJAX para registrar el empleado
$('#registrarEmpleadoBtn').click(function() {
    var nuevoEmpleado = {
        _token: '<?php echo e(csrf_token()); ?>', // Token CSRF para protección contra CSRF
        apaterno: $('#apellidoPaterno').val(),
        amaterno: $('#apellidoMaterno').val(),
        nombres: $('#nombres').val(),
        documento: $('#documento').val(),
        dni: $('#numeroDNI').val(),
        fecha_nacimiento: $('#fechaNacimiento').val(),
        sexo: $('#sexo').val(),
        departamento: $('#departamento').val(),
        provincia: $('#provincia').val(),
        distrito: $('#distrito').val(),
        direccion: $('#direccion').val(),
        celular: $('#celular').val(),
        correo: $('#correo').val(),
        estado: $('#estado').val()
        // Agrega más campos aquí según corresponda
    };

    // Realizar la solicitud AJAX
    $.ajax({
        url: "gempleado", // Ruta para la creación en el controlador
        type: 'POST',
        data: nuevoEmpleado,
        success: function(response) {
            console.log(response); // Manejar la respuesta del servidor aquí
        }
    });
});
</script>
<script>
// Puedes ejecutar este script cuando se carga la página o en respuesta a un evento, como un clic en un botón.
document.getElementById('enlace').addEventListener('click', function(event) {
    // Prevenir el comportamiento predeterminado del enlace para evitar que se abra en la ventana actual.
    event.preventDefault();

    // Abrir el enlace en una nueva ventana emergente.
    window.open(this.href, '_blank', 'width=900,height=600');
});
</script>
</html><?php /**PATH C:\xampp\htdocs\planilla-app\resources\views/view_empleado/empleado.blade.php ENDPATH**/ ?>