<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asistencia</title>

    <!-- Bootstrap CSS v5.2.1 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">



    <!-- jquery -->

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>

    <!-- Bootstrap JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous">
    </script>
    <!-- Bootstrap JavaScript Libraries -->

</head>

<body>



    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <center>
                    <h1 class="mb-4">CONTROL DE ASISTENCIA <div id="reloj"></div>
                    </h1>
                </center>

                <div class="card">


                    <div class="card">
                        <h5 class="card-header"> Ingresa tu Asistencia</h5>
                        <div class="card-body">
                            <label for="dni" class="form-label">DNI:</label>
                            <input type="text" class="form-control" id="dni" name="dni" required>
                            <p>
                            <div class="row mt-3">

                                <div class="d-grid gap-2">
                                    <button id="btnIngreso" class="btn btn-primary" type="button">Ingreso</button>
                                    <button id="btnReingreso" class="btn btn-success" type="button">Re-ingreso</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


</body>

</html>




<script>
$(document).ready(function() {


    /////////////////////////////////////
    function actualizarReloj() {
        var ahora = new Date();
        var horas = ahora.getHours();
        var minutos = ahora.getMinutes().toString().padStart(2, '0');
        var segundos = ahora.getSeconds().toString().padStart(2, '0');
        var ampm = horas >= 12 ? 'PM' : 'AM';
        horas = horas % 12;
        horas = horas ? horas : 12; // Las 12 en el formato de 12 horas es '12', no '0'
        var tiempo = horas + ':' + minutos + ':' + segundos + ' ' + ampm;
        document.getElementById('reloj').textContent = tiempo;
    }

    setInterval(actualizarReloj, 1000);
    actualizarReloj();

    ////////////////////////////////////////////////////////

    $("#btnIngreso").on("click", function() {
        registrarAsistencia('ingreso');
    });

    // Evento al hacer clic en el botón de Re-ingreso
    $("#btnReingreso").on("click", function() {
        registrarAsistencia('reingreso');
    });



    function registrarAsistencia(tipo) {
        var dni = $('#dni').val();

        $.ajax({
            url: 'gempleadoasiten', // Reemplaza con la URL correcta de tu script PHP
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                dni: dni,
                tipo: tipo // Envía el tipo de asistencia (ingreso o reingreso)
            },
            success: function(response) {
                alert(response.mensaje);
                // Puedes hacer más acciones después de un registro exitoso si es necesario.
            },
            error: function(error) {
                console.error('Error al registrar asistencia:', error);
                alert('Hubo un error al registrar la asistencia. Por favor, inténtalo de nuevo.');
            }
        });
    }



    ;

})
</script><?php /**PATH C:\xampp\htdocs\planilla-app\resources\views/view_asistencia/asis.blade.php ENDPATH**/ ?>