<!doctype html>
<html lang="en">

<head>
    <title>Title</title>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- css datatable -->

    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">

    <!-- Bootstrap CSS v5.2.1 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">


</head>

<body>

    <div class="container-fluid">
        <!-- Button trigger modal -->
        <div class="row">

            <div class="card">
                <div class="card-header">
                    DATOS DEL CONTRATO
                </div>
                <div class="card-body">
                    <form>
                        <!-- Fila para Nombres, Apellidos y Botón Buscar Personal -->
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Nombres</label>
                                    <input type="text" class="form-control" placeholder="Ingrese nombres">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Apellidos</label>
                                    <input type="text" class="form-control" placeholder="Ingrese apellidos">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="button" class="btn btn-primary form-control">Buscar Personal</button>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Fila para Fecha Inicio y Fecha Fin Contrato -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Fecha Inicio Contrato</label>
                                    <input type="date" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Fecha Fin Contrato</label>
                                    <input type="date" class="form-control">
                                </div>
                            </div>
                        </div>

                        <!-- Fila para Términos del Contrato -->
                        <div class="form-group">
                            <label>Términos del Contrato</label>
                            <textarea class="form-control" rows="3"></textarea>
                        </div>

                        <!-- Fila para Tipo de Contrato y Área -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tipo de Contrato</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Área</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                        </div>

                        <!-- Fila para Seguro y Cargo -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Seguro</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Cargo</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                        </div>

                        <!-- Fila para Sueldo y Estado -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Sueldo</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Estado</label>
                                    <input type="text" class="form-control">
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>


        </div>

        <div class="row">

            <div class="card">
                <div class="card-header">
                    ASIGNACION DE APORTACION FIJA
                </div>
                <div class="card-body">

                    <div class="row">
                        <form>
                            <!-- Resto de los campos del formulario aquí -->

                            <!-- Fila para el campo Select y Botones Agregar y Eliminar -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Seleccionar Opciones</label>
                                        <select id="opcionesSelect" class="form-control">
                                            <option value="opcion1">Opción 1</option>
                                            <option value="opcion2">Opción 2</option>
                                            <option value="opcion3">Opción 3</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="button" class="btn btn-primary form-control"
                                            onclick="agregarOpcion()">Agregar</button>
                                    </div>
                                </div>
                            </div>

                            <!-- Tabla para mostrar las opciones seleccionadas -->
                            <div class="form-group">
                                <label>Opciones Seleccionadas</label>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Opción</th>
                                            <th>Eliminar</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tablaOpcionesSeleccionadas"></tbody>
                                </table>
                            </div>

                            <button type="submit" class="btn btn-primary">Guardar</button>
                        </form>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <!-- jquery -->

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>

    <!-- Bootstrap JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous">
    </script>
    <!-- Bootstrap JavaScript Libraries -->

    <!-- datateble -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

</body>
<script>
$(document).ready(function() {
    let table = new DataTable('#myTable');

});
</script>





<script>
    var opcionesElegidas = [];

    function agregarOpcion() {
        var select = document.getElementById("opcionesSelect");
        var opcionSeleccionada = select.options[select.selectedIndex];

        // Verificar si la opción ya está en la lista
        if (opcionesElegidas.some(opcion => opcion.valor === opcionSeleccionada.value)) {
            alert("La opción ya ha sido agregada.");
        } else {
            opcionesElegidas.push({ valor: opcionSeleccionada.value, texto: opcionSeleccionada.textContent });
            actualizarTabla();
        }
    }

    function eliminarOpcion(index) {
        opcionesElegidas.splice(index, 1);
        actualizarTabla();
    }

    function actualizarTabla() {
        var tabla = document.getElementById("tablaOpcionesSeleccionadas");
        tabla.innerHTML = "";
        opcionesElegidas.forEach(function(opcion, index) {
            var fila = tabla.insertRow();
            var celdaOpcion = fila.insertCell();
            var celdaEliminar = fila.insertCell();

            celdaOpcion.textContent = opcion.texto;

            var botonEliminar = document.createElement("button");
            botonEliminar.textContent = "Eliminar";
            botonEliminar.className = "btn btn-danger";
            botonEliminar.onclick = function() {
                eliminarOpcion(index);
            };

            celdaEliminar.appendChild(botonEliminar);
        });
    }
</script>















</html><?php /**PATH C:\xampp\htdocs\planilla-app\resources\views/view_contrato/ncontrato.blade.php ENDPATH**/ ?>